/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.contraption.train;

import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.trains.track.AllPortalTracks;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface PortalTrackProvider {
    public static final SimpleRegistry<Block, PortalTrackProvider> REGISTRY = SimpleRegistry.create();

    public Exit findExit(ServerLevel var1, BlockFace var2);

    public static boolean isSupportedPortal(BlockState state) {
        return REGISTRY.get((StateHolder<Block, ?>)state) != null;
    }

    @Nullable
    public static Exit getOtherSide(ServerLevel level, BlockFace inboundTrack) {
        BlockPos portalPos = inboundTrack.getConnectedPos();
        BlockState portalState = level.m_8055_(portalPos);
        PortalTrackProvider provider = REGISTRY.get((StateHolder<Block, ?>)portalState);
        return provider == null ? null : provider.findExit(level, inboundTrack);
    }

    public static Exit fromTeleporter(ServerLevel level, BlockFace face, ResourceKey<Level> firstDimension, ResourceKey<Level> secondDimension, Function<ServerLevel, ITeleporter> customPortalForcer) {
        return AllPortalTracks.fromTeleporter(level, face, firstDimension, secondDimension, customPortalForcer);
    }

    public static Exit fromProbe(ServerLevel level, BlockFace face, ResourceKey<Level> firstDimension, ResourceKey<Level> secondDimension, BiFunction<ServerLevel, SuperGlueEntity, PortalInfo> portalInfoProvider) {
        return AllPortalTracks.fromProbe(level, face, firstDimension, secondDimension, portalInfoProvider);
    }

    public record Exit(ServerLevel level, BlockFace face) {
    }
}

